//=============================================================================
// Vial.
//=============================================================================
class Realms_Item_StatPoint extends HealthVial;

#exec obj load file=..\Sounds\AmbAncient.uax package=AmbAncient
// Include EditPackages=BotPack in UnrealTournament.ini

#exec mesh import mesh=StatPoint anivfile=Models\StatPoint_a.3d datafile=Models\StatPoint_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=StatPoint x=0 y=0 z=0
#exec mesh sequence mesh=StatPoint seq=All startframe=0 numframes=1

#exec meshmap new meshmap=StatPoint mesh=StatPoint
#exec meshmap scale meshmap=StatPoint x=0.06250 y=0.06250 z=0.12500

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
function Touch( actor Other )
	{
	
	local Realms_Models_MaleKnight KnightP;
			
	if ( ValidTouch(Other) ) 
		{	
		if ( Other.IsA('Realms_Models_MaleKnight'))	
			KnightP.StatPoints++;

		PlayPickupMessage(KnightP);
		PlaySound (PickupSound,,2.5);
		Other.MakeNoise(0.2);		
		SetRespawn();
			
		}
	}
}




defaultproperties
{
     HealingAmount=0
     bSuperHeal=False
     PickupMessage="You got an extra StatPoint"
     ItemName="StatPoint"
     RespawnTime=999999999.000000
     PickupViewMesh=Mesh'StatPoint'
     PickupSound=Sound'AmbAncient.OneShot.bhit1'
     Mesh=Mesh'StatPoint'
     ScaleGlow=2.000000
     CollisionRadius=16.000000
     CollisionHeight=16.000000
     MultiSkins(0)=Texture'StatIcon'
     MultiSkins(1)=Texture'Botpack.ShaneFx.top3'
     bRotatingPickup=True
     RotationRate=(Roll=20000)
     RotationRate=(Pitch=18000)
     RotationRate=(Yaw=16000)
     bCollideWhenPlacing=True
}
